﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web;

namespace NVCC.Models
{
    [Serializable]
    public class UploadedFile
    {
        public int Size { get; set; }
        public string FullPath { get; set; }
        public string OriginalFileName { get; set; }
        public bool Remove { get; set; }
        //This is a decimal instead of an int so that the result of Size/BytesInMB is a decimal.
        private const decimal BytesInMB = 1048576M;
        public decimal SizeInMB
        {
            get
            {
                return Math.Round((Size / BytesInMB), 2);
            }
        }

        public UploadedFile()
        {

        }

        public UploadedFile(HttpPostedFileBase file)
        {
            OriginalFileName = Path.GetFileName(file.FileName);
            Size = file.ContentLength;
            FullPath = SaveFile(file);
            Remove = false;
        }


        private string SaveFile(HttpPostedFileBase file)
        {
            var filePath = Path.GetTempFileName();
            file.SaveAs(filePath);

            return filePath;
        }


    }
}
